/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.mobholder;

import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.block.util.CapturedMobsHelper;
import net.mehvahdjukaar.supplementaries.common.capabilities.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.mobholder.BaseCatchableMobCap;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.items.AbstractMobContainerItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class DefaultCatchableMobCap<T extends Entity>
extends BaseCatchableMobCap<T> {
    private final CapturedMobsHelper.CapturedMobConfigProperties properties;
    protected float jumpY = 0.0f;
    protected float prevJumpY = 0.0f;
    protected float yVel = 0.0f;

    public DefaultCatchableMobCap(T entity2) {
        super(entity2);
        this.properties = CapturedMobsHelper.getType(entity2);
    }

    @Override
    public float getHitBoxWidthIncrement() {
        return this.properties.getWidth();
    }

    @Override
    public float getHitBoxHeightIncrement() {
        return this.properties.getHeight();
    }

    @Override
    public int getLightLevel() {
        return this.properties.getLightLevel();
    }

    @Override
    public boolean canBeCaughtWithItem(Item item2) {
        if (this.mob instanceof SlimeEntity && ((SlimeEntity)this.mob).func_70809_q() > 1) {
            return false;
        }
        if (this.mob instanceof BeeEntity) {
            return true;
        }
        if (item2 instanceof AbstractMobContainerItem) {
            return ((AbstractMobContainerItem)item2).canItemCatch(this.mob);
        }
        return false;
    }

    @Override
    public boolean canBeCaughtWithJar() {
        return false;
    }

    @Override
    public boolean canBeCaughtWithTintedJar() {
        return false;
    }

    @Override
    public boolean canBeCaughtWithCage() {
        return false;
    }

    @Override
    public void tickInsideContainer(World world, BlockPos pos, float mobScale, CompoundNBT tag) {
        if (world.field_72995_K) {
            if (this.properties.isFloating()) {
                this.jumpY = 0.04f * MathHelper.func_76126_a((float)((float)this.mob.field_70173_aa / 10.0f)) - 0.03f;
            }
            this.mob.field_70137_T = this.mob.func_226278_cu_();
            float dy = this.jumpY - this.prevJumpY;
            if (dy != 0.0f) {
                this.mob.func_70107_b(this.mob.func_226277_ct_(), this.mob.func_226278_cu_() + (double)dy, this.mob.func_226281_cx_());
            }
            this.prevJumpY = this.jumpY;
        }
    }

    @Override
    public boolean isFlyingMob() {
        CapturedMobsHelper.AnimationCategory cat = this.getAnimationCategory();
        return !cat.isLand() && (cat.isFlying() || this.mob.func_189652_ae() || this.mob instanceof IFlyingAnimal || this.mob.func_145773_az() || this.mob instanceof WaterMobEntity);
    }

    public CapturedMobsHelper.AnimationCategory getAnimationCategory() {
        return this.properties.getCategory();
    }

    public static <E extends Entity> ICatchableMob getDefaultCap(E e) {
        if (e.field_70170_p.field_72995_K && e instanceof LivingEntity && ((List)ClientConfigs.block.TICKLE_MOBS.get()).contains(e.func_200600_R().getRegistryName().toString())) {
            return new ClientTickableAnim((LivingEntity)e);
        }
        if (e instanceof SquidEntity) {
            return new DoubleSideTickableAnim((LivingEntity)e);
        }
        if (e instanceof SlimeEntity) {
            return new SlimeAnim((SlimeEntity)e);
        }
        if (e instanceof ParrotEntity) {
            return new ParrotAnim((ParrotEntity)e);
        }
        if (e instanceof RabbitEntity) {
            return new RabbitAnim((RabbitEntity)e);
        }
        if (e instanceof ChickenEntity) {
            return new ChickenAnim((ChickenEntity)e);
        }
        if (e instanceof EndermiteEntity) {
            return new EndermiteAnim((EndermiteEntity)e);
        }
        return new DefaultCatchableMobCap<E>(e);
    }

    public static class ClientTickableAnim
    extends DefaultCatchableMobCap<LivingEntity> {
        public ClientTickableAnim(LivingEntity entity2) {
            super(entity2);
        }

        @Override
        public void tickInsideContainer(World world, BlockPos pos, float mobScale, CompoundNBT tag) {
            if (world.field_72995_K) {
                ((LivingEntity)this.mob).func_70636_d();
                super.tickInsideContainer(world, pos, mobScale, tag);
            }
        }
    }

    public static class DoubleSideTickableAnim
    extends DefaultCatchableMobCap<LivingEntity> {
        public DoubleSideTickableAnim(LivingEntity entity2) {
            super(entity2);
        }

        @Override
        public void tickInsideContainer(World world, BlockPos pos, float mobScale, CompoundNBT tag) {
            ((LivingEntity)this.mob).func_70636_d();
            if (world.field_72995_K) {
                super.tickInsideContainer(world, pos, mobScale, tag);
            }
        }
    }

    public static class EndermiteAnim
    extends DefaultCatchableMobCap<EndermiteEntity> {
        public EndermiteAnim(EndermiteEntity entity2) {
            super(entity2);
        }

        @Override
        public void tickInsideContainer(World world, BlockPos pos, float mobScale, CompoundNBT tag) {
            if (world.field_72995_K) {
                if (world.field_73012_v.nextFloat() > 0.7f) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.2f), (double)((float)pos.func_177952_p() + 0.5f), (world.field_73012_v.nextDouble() - 0.5) * 2.0, -world.field_73012_v.nextDouble(), (world.field_73012_v.nextDouble() - 0.5) * 2.0);
                }
                super.tickInsideContainer(world, pos, mobScale, tag);
            }
        }
    }

    public static class ParrotAnim
    extends DefaultCatchableMobCap<ParrotEntity> {
        public ParrotAnim(ParrotEntity entity2) {
            super(entity2);
        }

        @Override
        public void tickInsideContainer(World world, BlockPos pos, float mobScale, CompoundNBT tag) {
            if (world.field_72995_K) {
                ((ParrotEntity)this.mob).func_70636_d();
                boolean p = ((ParrotEntity)this.mob).func_192004_dr();
                ((ParrotEntity)this.mob).func_230245_c_(p);
                this.jumpY = p ? 0.0f : 0.0625f;
                super.tickInsideContainer(world, pos, mobScale, tag);
            }
        }
    }

    public static class RabbitAnim
    extends DefaultCatchableMobCap<RabbitEntity> {
        public RabbitAnim(RabbitEntity entity2) {
            super(entity2);
        }

        @Override
        public void tickInsideContainer(World world, BlockPos pos, float mobScale, CompoundNBT tag) {
            if (world.field_72995_K) {
                if (this.yVel != 0.0f) {
                    this.jumpY = Math.max(0.0f, this.jumpY + this.yVel);
                }
                if (this.jumpY != 0.0f) {
                    this.yVel -= 0.017f;
                } else {
                    if (this.yVel != 0.0f) {
                        this.yVel = 0.0f;
                    }
                    if ((double)world.field_73012_v.nextFloat() > 0.985) {
                        this.yVel = 0.093f;
                        ((RabbitEntity)this.mob).func_184770_cZ();
                    }
                }
                ((RabbitEntity)this.mob).func_70636_d();
                super.tickInsideContainer(world, pos, mobScale, tag);
            }
        }
    }

    public static class ChickenAnim
    extends DefaultCatchableMobCap<ChickenEntity> {
        public ChickenAnim(ChickenEntity entity2) {
            super(entity2);
        }

        @Override
        public void tickInsideContainer(World world, BlockPos pos, float mobScale, CompoundNBT tag) {
            Random rand = world.func_201674_k();
            if (!world.field_72995_K) {
                if (--((ChickenEntity)this.mob).field_70887_j <= 0) {
                    ((ChickenEntity)this.mob).func_199703_a((IItemProvider)Items.field_151110_aK);
                    ((ChickenEntity)this.mob).field_70887_j = rand.nextInt(6000) + 6000;
                }
            } else {
                ((ChickenEntity)this.mob).func_70636_d();
                double d = world.field_73012_v.nextFloat();
                double d2 = ((ChickenEntity)this.mob).func_233570_aj_() ? 0.99 : 0.88;
                if (d > d2) {
                    ((ChickenEntity)this.mob).func_230245_c_(!((ChickenEntity)this.mob).func_233570_aj_());
                }
                super.tickInsideContainer(world, pos, mobScale, tag);
            }
        }
    }

    public static class SlimeAnim
    extends DefaultCatchableMobCap<SlimeEntity> {
        public SlimeAnim(SlimeEntity entity2) {
            super(entity2);
        }

        @Override
        public void tickInsideContainer(World world, BlockPos pos, float mobScale, CompoundNBT tag) {
            if (world.field_72995_K) {
                ((SlimeEntity)this.mob).field_70811_b += (((SlimeEntity)this.mob).field_70813_a - ((SlimeEntity)this.mob).field_70811_b) * 0.5f;
                ((SlimeEntity)this.mob).field_70812_c = ((SlimeEntity)this.mob).field_70811_b;
                if (this.yVel != 0.0f) {
                    this.jumpY = Math.max(0.0f, this.jumpY + this.yVel);
                }
                if (this.jumpY != 0.0f) {
                    this.yVel -= 0.01f;
                } else {
                    if (this.yVel != 0.0f) {
                        this.yVel = 0.0f;
                        ((SlimeEntity)this.mob).field_70813_a = -0.5f;
                    }
                    if ((double)world.func_201674_k().nextFloat() > 0.985) {
                        this.yVel = 0.08f;
                        ((SlimeEntity)this.mob).field_70813_a = 1.0f;
                    }
                }
                ((SlimeEntity)this.mob).field_70813_a *= 0.6f;
                super.tickInsideContainer(world, pos, mobScale, tag);
            }
        }
    }
}

